.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "LOAD" "" "29 March 2001" "SQL - Language Statements" "SQL Commands"
.SH NAME
LOAD \- Dynamically loads an object file
.SH SYNOPSIS
.sp
.nf
LOAD '\fIfilename\fR'
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIfilename\fB\fR
Object file for dynamic loading.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBLOAD\fR
Message returned on successful completion.
.TP
\fBERROR: LOAD: could not open file '\fIfilename\fB'\fR
Message returned if the specified file is not found. The file must be visible
\fBto the Postgres backend\fR,
with the appropriate full path name specified, to avoid this message.
.PP
.SH "DESCRIPTION"
.PP
Loads an object (or ".o") file into the 
Postgres backend address space. Once a
file is loaded, all functions in that file can be accessed. This
function is used in support of user-defined types and functions.
.PP
If a file is not loaded using
\fBLOAD\fR, 
the file will be loaded automatically the first time the
function is called by Postgres.
\fBLOAD\fR
can also be used to reload an object file if it has been edited and
recompiled. Only objects created from C language files are supported
at this time.
.SS "NOTES"
.PP
Functions in loaded object files should not call functions in other
object files loaded through the
\fBLOAD\fR
command. For example, all functions in file A should
call each other, functions in the standard or math libraries, or in
Postgres itself. They should not call functions defined in a different
loaded file B.
This is because if B is reloaded, the Postgres loader is
not able to relocate the calls from the functions in
A into
the new address space of B.
If B is not reloaded, however, there will
not be a problem.
.PP
Object files must be compiled to contain position independent code.
For example, 
on DECstations you must use
\fB/bin/cc\fR
with the -G 0 option when compiling object files to be
loaded.
.PP
Note that if you are porting Postgres
to a new platform, \fBLOAD\fR
will have to work in order to support ADTs.
.SH "USAGE"
.PP
Load the file \fI/usr/postgres/demo/circle.o\fR:
.sp
.nf
LOAD '/usr/postgres/demo/circle.o'
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no \fBLOAD\fR in SQL92.
