.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "DROP_TRIGGER" "l" "08 May 2000" "SQL - Language Statements" ""
.SH NAME
DROP TRIGGER \- Removes the definition of a trigger
.SH SYNOPSIS
.sp
.nf
DROP TRIGGER \fIname\fR ON \fItable\fR
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
The name of an existing trigger.
.TP
\fB\fItable\fB\fR
The name of a table.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBDROP\fR
The message returned if the trigger is successfully dropped.
.TP
\fBERROR: DropTrigger: there is no trigger \fIname\fB on relation "\fItable\fB"\fR
This message occurs if the trigger specified does not exist.
.PP
.SH "DESCRIPTION"
.PP
\fBDROP TRIGGER\fR will remove all references to an existing
trigger definition. To execute this command the current
user must be the owner of the trigger.
.SS "NOTES"
.PP
\fBDROP TRIGGER\fR is a Postgres
language extension.
.PP
Refer to \fBCREATE TRIGGER\fR for
information on how to create triggers.
.SH "USAGE"
.PP
Destroy the if_dist_exists trigger
on table films:
.sp
.nf
DROP TRIGGER if_dist_exists ON films;
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no \fBDROP TRIGGER\fR statement in
SQL92.
