.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "LOCK" "l" "08 May 2000" "SQL - Language Statements" ""
.SH NAME
LOCK \- Explicitly lock a table inside a transaction
.SH SYNOPSIS
.sp
.nf
LOCK [ TABLE ] \fIname\fR
LOCK [ TABLE ] \fIname\fR IN [ ROW | ACCESS ] { SHARE | EXCLUSIVE } MODE
LOCK [ TABLE ] \fIname\fR IN SHARE ROW EXCLUSIVE MODE
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
The name of an existing table to lock.
.TP
\fBACCESS SHARE MODE\fR
.sp
.RS
.B "Note:"
This lock mode is acquired automatically over tables being queried.
.RE
.sp
This is the least restrictive lock mode. It conflicts only with
ACCESS EXCLUSIVE mode. It is used to protect a table from being
modified by concurrent \fBALTER TABLE\fR, 
\fBDROP TABLE\fR and \fBVACUUM\fR 
commands.
.TP
\fBROW SHARE MODE\fR
.sp
.RS
.B "Note:"
Automatically acquired by \fBSELECT...FOR UPDATE\fR.
While it is a shared lock, may be upgrade later to a ROW EXCLUSIVE lock.
.RE
.sp
Conflicts with EXCLUSIVE and ACCESS EXCLUSIVE lock modes.
.TP
\fBROW EXCLUSIVE MODE\fR
.sp
.RS
.B "Note:"
Automatically acquired by \fBUPDATE\fR, 
\fBDELETE\fR, and \fBINSERT\fR
statements.
.RE
.sp
Conflicts with SHARE, SHARE ROW EXCLUSIVE, EXCLUSIVE and
ACCESS EXCLUSIVE modes.
.TP
\fBSHARE MODE\fR
.sp
.RS
.B "Note:"
Automatically acquired by \fBCREATE INDEX\fR.
Share-locks the entire table.
.RE
.sp
Conflicts with ROW EXCLUSIVE, SHARE ROW EXCLUSIVE, EXCLUSIVE and
ACCESS EXCLUSIVE modes. This mode protects a table against
concurrent updates.
.TP
\fBSHARE ROW EXCLUSIVE MODE\fR
.sp
.RS
.B "Note:"
This is like EXCLUSIVE MODE, but allows SHARE ROW locks
by others.
.RE
.sp
Conflicts with ROW EXCLUSIVE, SHARE, SHARE ROW EXCLUSIVE,
EXCLUSIVE and ACCESS EXCLUSIVE modes.
.TP
\fBEXCLUSIVE MODE\fR
.sp
.RS
.B "Note:"
This mode is yet more restrictive than SHARE ROW EXCLUSIVE. 
It blocks all concurrent ROW SHARE/SELECT...FOR UPDATE queries.
.RE
.sp
Conflicts with ROW SHARE, ROW EXCLUSIVE, SHARE, SHARE ROW EXCLUSIVE,
EXCLUSIVE and ACCESS EXCLUSIVE modes.
.TP
\fBACCESS EXCLUSIVE MODE\fR
.sp
.RS
.B "Note:"
Automatically acquired by \fBALTER TABLE\fR,
\fBDROP TABLE\fR, \fBVACUUM\fR statements.
This is the most restrictive lock mode which conflicts with all other
lock modes and protects a locked table from any concurrent operations.
.RE
.sp
.sp
.RS
.B "Note:"
This lock mode is also acquired by an unqualified
\fBLOCK TABLE\fR (i.e. the command without an explicit
lock mode option).
.RE
.sp
.PP
.SS "OUTPUTS"
.PP
.TP
\fBLOCK TABLE\fR
The lock was successfully applied.
.TP
\fBERROR \fIname\fB: Table does not exist.\fR
Message returned if \fIname\fR
does not exist.
.PP
.SH "DESCRIPTION"
.PP
\fBLOCK TABLE\fR controls concurrent access to a table
for the duration of a transaction.
Postgres always uses the least restrictive
lock mode whenever possible. \fBLOCK TABLE\fR 
provided for cases when you might need more restrictive locking.
.PP
RDBMS locking uses the following terminology:
.TP
\fBEXCLUSIVE\fR
Exclusive lock that prevents other locks from being granted.
.TP
\fBSHARE\fR
Allows others to share lock. Prevents EXCLUSIVE locks.
.TP
\fBACCESS\fR
Locks table schema.
.TP
\fBROW\fR
Locks individual rows.
.PP
.sp
.RS
.B "Note:"
If EXCLUSIVE or SHARE are not specified, EXCLUSIVE is assumed.
Locks exist for the duration of the transaction.
.PP
.RE
.sp
.PP
For example, an application runs a transaction at READ COMMITTED isolation
level and needs to ensure the existance of data in a table for the
duration of the
transaction. To achieve this you could use SHARE lock mode over the
table before querying. This will protect data from concurrent changes 
and provide any further read operations over the table with data in their 
actual current state, because SHARE lock mode conflicts with any ROW EXCLUSIVE 
one acquired by writers, and your
\fBLOCK TABLE \fIname\fB IN SHARE MODE\fR
statement will wait until any concurrent write operations commit or rollback.
.sp
.RS
.B "Note:"
To read data in their real current state when running a transaction
at the SERIALIZABLE isolation level you have to execute a LOCK TABLE
statement before execution any DML statement, when the transaction defines
what concurrent changes will be visible to itself.
.RE
.sp
.PP
In addition to the requirements above, if a transaction is going to
change data in a table then SHARE ROW EXCLUSIVE lock mode should
be acquired to prevent deadlock conditions when two concurrent
transactions attempt to lock the table in SHARE mode and then
try to change data in this table, both (implicitly) acquiring 
ROW EXCLUSIVE lock mode that conflicts with concurrent SHARE lock.
.PP
To continue with the deadlock (when two transaction wait one another)
issue raised above, you should follow two general rules to prevent 
deadlock conditions:
.TP 0.2i
\(bu
Transactions have to acquire locks on the same objects in the same order.

For example, if one application updates row R1 and than updates 
row R2 (in the same transaction) then the second application shouldn't 
update row R2 if it's going to update row R1 later (in a single transaction). 
Instead, it should update rows R1 and R2 in the same order as the first 
application.
.TP 0.2i
\(bu
Transactions should acquire two conflicting lock modes only if
one of them is self-conflicting (i.e. may be held by one
transaction at time only). If multiple lock modes are involved,
then transactions should always acquire the most restrictive mode first.

An example for this rule was given previously when discussing the 
use of SHARE ROW EXCLUSIVE mode rather than SHARE mode.
.sp
.RS
.B "Note:"
Postgres does detect deadlocks and will
rollback at least one waiting transaction to resolve the deadlock. 
.PP
.RE
.sp
.SS "NOTES"
.PP
\fBLOCK\fR is a Postgres
language extension.
.PP
Except for ACCESS SHARE/EXCLUSIVE lock modes, all other
Postgres lock modes and the
\fBLOCK TABLE\fR syntax are compatible with those
present in Oracle.
.PP
\fBLOCK\fR works only inside transactions.
.SH "USAGE"
.PP
Illustrate a SHARE lock on a primary key table when going to perform
inserts into a foreign key table:
.sp
.nf
BEGIN WORK;
LOCK TABLE films IN SHARE MODE;
SELECT id FROM films 
    WHERE name = 'Star Wars: Episode I - The Phantom Menace';
-- Do ROLLBACK if record was not returned
INSERT INTO films_user_comments VALUES 
    (_id_, 'GREAT! I was waiting for it for so long!');
COMMIT WORK;
   
.sp
.fi
.PP
Take a SHARE ROW EXCLUSIVE lock on a primary key table when going to perform
a delete operation:
.sp
.nf
BEGIN WORK;
LOCK TABLE films IN SHARE ROW EXCLUSIVE MODE;
DELETE FROM films_user_comments WHERE id IN
    (SELECT id FROM films WHERE rating < 5);
DELETE FROM films WHERE rating < 5;
COMMIT WORK;
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no \fBLOCK TABLE\fR in SQL92,
which instead uses \fBSET TRANSACTION\fR to specify
concurrency levels on transactions. We support that too; see
\fBset\fR(l) for details.
