/* $Id: encoding.c,v 1.4 2005/11/20 03:33:27 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * Encoding choreography
 */
#include <setjmp.h>
#include <postgres.h>
#include <mb/pg_wchar.h>
#include <pypg/environment.h>

#include <Python.h>
#include <structmember.h>
#include <pypg/python.h>
#include <pypg/externs.h>
#include <pypg/encoding.h>

#if PGV_MM < 81
#define PG_WIN866 PG_ALT
#define PG_WIN1258 PG_TCVN
#endif

const char *
PyEncoding_FromPgEncoding(pg_enc e)
{
	const char *r = NULL;
	switch (e)
	{
		case PG_SQL_ASCII:
			r = "ascii";
		break;
		case PG_EUC_JP:
			r = "eucjp";
		break;
		case PG_EUC_CN:
			r = "euccn";
		break;
		case PG_EUC_KR:
			r = "euckr";
		break;
		case PG_EUC_TW:
			r = NULL;
		break;
		case PG_JOHAB:
			r = "johab";
		break;
		case PG_UTF8:
			r = "utf_8";
		break;
		case PG_MULE_INTERNAL:
			r = NULL;
		break;
		case PG_LATIN1:
			r = "latin1";
		break;
		case PG_LATIN2:
			r = "latin2";
		break;
		case PG_LATIN3:
			r = "latin3";
		break;
		case PG_LATIN4:
			r = "latin4";
		break;
		case PG_LATIN5:
			r = "latin5";
		break;
		case PG_LATIN6:
			r = "latin6";
		break;
		case PG_LATIN7:
			r = "latin7";
		break;
		case PG_LATIN8:
			r = "latin8";
		break;
		case PG_LATIN9:
			r = "latin9";
		break;
		case PG_LATIN10:
			r = "latin10";
		break;
		case PG_WIN1256:
			r = "windows_1256";
		break;
		case PG_WIN866:
			r = "cp866";
		break;
		case PG_WIN874:
			r = "cp874";
		break;
		case PG_WIN1250:
			r = "windows_1250";
		break;
		case PG_WIN1258:
			r = "windows_1258";
		break;
		case PG_KOI8R:
			r = "koi8_r";
		break;
		case PG_WIN1251:
			r = "windows_1251";
		break;
		case PG_ISO_8859_5:
			r = "iso8859_5";
		break;
		case PG_ISO_8859_6:
			r = "iso8859_6";
		break;
		case PG_ISO_8859_7:
			r = "iso8859_7";
		break;
		case PG_ISO_8859_8:
			r = "iso8859_8";
		break;
		case PG_SJIS:
			r = "sjis";
		break;
		case PG_BIG5:
			r = "big5";
		break;
		case PG_GBK:
			r = "gbk";
		break;
		case PG_UHC:
			r = "uhc";
		break;
		case PG_GB18030:
			r = "gb18030";
		break;
		default:
			r = NULL;
		break;
	}

	return(r);
}

static int
init_aliases
(
	PyObj aliases,
	PyObj normalize_encoding,
	unsigned int tbl_sz,
	pg_encname *tbl
)
{
	int i;
	/*
	 * This is designed to handle both NULL terminated
	 * pg_encname and size specified pg_enc2name.
	 */
	for (i = 0; i < tbl_sz; ++i)
	{
		const char *pyenc;
		PyObj curstr, ne;
		pg_encname *enc;

		enc = &(tbl[i]);
		pyenc = PyEncoding_FromPgEncoding(enc->encoding);
		if (pyenc == NULL || strcasecmp(pyenc, enc->name) == 0)
		{
			/*
			 * If Python core either already has the encoding, or doesn't
			 * have the encoding, continue on as there is either nothing to
			 * do or nothing that can be done.
			 */
			continue;
		}

		curstr = PyString_FromString(enc->name);
		if (curstr == NULL)
			goto fail;
		ne = Py_Call(normalize_encoding, curstr);
		Py_DECREF(curstr);
		if (ne == NULL)
			goto fail;
		curstr = PyString_FromString(pyenc);
		PyDict_SetItem(aliases, ne, curstr);
		Py_DECREF(curstr);
		Py_DECREF(ne);
		if (PyErr_Occurred())
			goto fail;
	}

	return(0);
fail:
	return(-1);
}

int
PyPgEncoding_Initialize(void)
{
	PyObj aliases, ne;

	aliases = PyImport_ImportModule("encodings.aliases");
	if (aliases == NULL)
		goto fail;
	Py_DECREF(aliases);
	aliases = PyObject_GetAttrString(aliases, "aliases");
	if (aliases == NULL)
		goto fail;
	Py_DECREF(aliases);

	ne = PyImport_ImportModule("encodings");
	if (ne == NULL)
		goto fail_aliases;
	Py_DECREF(ne);
	ne = PyObject_GetAttrString(ne, "normalize_encoding");
	if (ne == NULL)
		goto fail_aliases;

	if (init_aliases(aliases, ne, pg_encname_tbl_sz, pg_encname_tbl) < 0)
		goto fail_encoding;
	if (init_aliases(aliases, ne, _PG_LAST_ENCODING_ - 1,
				(pg_encname *) pg_enc2name_tbl) < 0)
		goto fail_encoding;

	return(0);
fail_encoding:
	Py_DECREF(ne);
fail_aliases:
	Py_DECREF(aliases);
fail:
	return(-1);
}
