/* $Id: object.h,v 1.3 2005/12/14 06:37:20 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * Postgres object interface for Python
 */
#ifndef PyPg_type_object_H
#define PyPg_type_object_H 0
#ifdef __cplusplus
extern "C" {
#endif

#ifndef PyPg_ci_H
extern PyPgTypeObject PyPgObject_Type;
extern PyPgTypeObject PyPgPseudo_Type;
extern PyPgTypeObject PyPgArbitrary_Type;

PyObj PyPgObject_typinput(PyObj, PyObj);
PyObj PyPgObject_typreceive(PyObj, PyObj);
PyObj PyPgObject_typoutput(PyObj);
PyObj PyPgObject_typsend(PyObj);

PyObj PyPgObject_FromPyPgTypeAndDatum(PyObj, Datum);
PyObj PyPgObject_FromTypeOidAndDatum(Oid, Datum);
PyObj PyPgObject_FromPyPgTypeAndHeapTuple(PyObj, HeapTuple);

Datum PyPg_datumCopy(Datum d, bool typbyval, int typlen);
PyObj PyPgObject_cast(PyObj, PyObj);
PyObj PyPgArbitrary_new(PyTypeObject *, PyObj, PyObj);
#else
#define PyPgObject_Type (*(PyPgCI._PyPgObject_Type))
#define PyPgPseudo_Type (*(PyPgCI._PyPgPseudo_Type))
#define PyPgArbitrary_Type (*(PyPgCI._PyPgArbitrary_Type))
#define PyPgArbitrary_new (PyPgCI._PyPgArbitrary_new)
#endif

#define PyPgArbitrary_Check(SELF) \
	(PyObject_TypeCheck((SELF), &PyPgArbitrary_Type))
#define PyPgArbitrary_CheckExact(SELF) \
	((SELF)->ob_type == &PyPgArbitrary_Type)

PyObj PyPgObject_Initialize(PyObj, Datum);
PyObj PyPgObject_Operate(const char *, PyObj, PyObj);

#define PyPgObject_BODY	\
	Datum pgo_datum;

#define PyPgObject_HEAD	\
	PyObject_HEAD			\
	PyPgObject_BODY

typedef struct PyPgObject {
	PyPgObject_HEAD
} * PyPgObject;

#define PyPgObject(SELF) ((PyPgObject) SELF)

#define PyPgObject_New(typ, datum) \
	PyPgObject_Initialize(PyPgObject_NEW(typ), datum)
#define PyPgObject_NEW(typ) \
	((PyTypeObject *) typ)->tp_alloc(((PyTypeObject *) typ), 0)

#define PyPgObject_Check(SELF) \
	(PyObject_TypeCheck((SELF), ((PyTypeObject *) &PyPgObject_Type)))
#define PyPgObject_CheckExact(SELF) \
	((SELF)->ob_type == ((PyTypeObject *) &PyPgObject_Type))

#define PyPgObject_ShouldFree(SELF) \
	!(PyPgObject_FetchTypeCache(SELF)->typbyval)

#define PyPgObject_FromPyPgTypeAndPyObject(TYPE, SELF) \
	(PyObject_CallFunctionObjArgs(TYPE, SELF, NULL))

#define PyPgObject_FetchDatum(SELF)	(PyPgObject(SELF)->pgo_datum)
#define PyPgObject_FetchType(SELF)	(SELF->ob_type)

#define PyPgObject_FetchTypeCache(SELF) \
	(PyPgType_FetchTypeCache(SELF->ob_type))
#define PyPgObject_FetchTypeOid(SELF) \
	(PyPgType_FetchOid(PyPgObject_FetchType(SELF)))

#define PyPgObject_FetchHeapTupleHeader(SELF) \
	((HeapTupleHeader) PyPgObject_FetchDatum(SELF))
#define PyPgObject_FetchStructure(SELF) \
	(HeapTupleHeaderStructure(PyPgObject_FetchHeapTupleHeader(SELF)))
#define PyPgObject_FetchTypeHeapTupleHeader(SELF) \
	PyPgObject_FetchHeapTupleHeader(PyPgObject_FetchType(SELF))
#define PyPgObject_FetchOid(SELF) \
	(HeapTupleHeaderGetOid(PyPgObject_FetchHeapTupleHeader(SELF)))
#define PyPgObject_FetchTypeOutput(SELF) \
	(PyPgType_FetchTypeOutput(PyPgObject_FetchType(SELF)))
#define PyPgObject_FetchTypeSend(SELF) \
	(PyPgType_FetchTypeSend(PyPgObject_FetchType(SELF)))
#define PyPgObject_FetchTypeStruct(SELF) \
	(PyPgType_FetchTypeStruct(PyPgObject_FetchType(SELF)))
#define PyPgObject_FetchTypeLength(SELF) \
	(PyPgObject_FetchTypeStruct(SELF)->typlen)
#define PyPgObject_FetchTypeByValue(SELF) \
	(PyPgObject_FetchTypeStruct(SELF)->typbyval)
#define PyPgObject_FetchPyPgTupleDesc(SELF) \
	(PyPgType_FetchPyPgTupleDesc(PyPgObject_FetchType(SELF)))
#define PyPgObject_FetchTupleDesc(SELF) \
	(PyPgTupleDesc_FetchTupleDesc(PyPgObject_FetchPyPgTupleDesc(SELF)))

#define PyPgObject_FetchVARSIZE(SELF) \
	(VARSIZE(PyPgObject_FetchDatum(SELF)))
#define PyPgObject_FetchStringLength(SELF) \
	(strlen((char *) PyPgObject_FetchDatum(SELF)))
#define PyPgObject_FetchLength(SELF) (				\
	(PyPgObject_FetchTypeByValue(SELF))			?(	\
	(PyPgObject_FetchTypeLength(SELF))			:	\
		(PyPgObject_FetchTypeLength(SELF) == -2)	?(	\
		(PyPgObject_FetchStringLength(SELF))		:	\
			(PyPgObject_FetchTypeLength(SELF) == -1)	?(	\
				(PyPgObject_FetchVARSIZE(SELF))				:	\
				(PyPgObject_FetchTypeLength(SELF))				\
			)																\
		)																	\
	)																\
)

#define PyPgObject_FixDatum(SELF, D) (PyPgObject(SELF)->pgo_datum = D)

#define PyPgObject_IsComposite(SELF) \
	(PyPgType_IsComposite(SELF->ob_type))
#ifdef __cplusplus
}
#endif
#endif /* !PyPg_type_object_H */
/*
 * vim: ts=3:sw=3:noet:
 */
