/*
 * Generated by XCodeGen v0.1
 * Sun Jun 16 19:57:29 EDT 2002
 */

package output.dao;

import java.util.HashSet;
import java.util.Set;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Types;
import output.dto.UserDTO;

/**
 * User of the system
 *
 * @author Herve Tchepannou
 * @version 
 *
 * @see UserDTO
 */
public class UserDAO
{
    /** INSERT SQL statement */
    public static final String SQL_INSERT = "INSERT INTO USR(id,firstname,lastname,email,login,password,disabled,disabledText) VALUES(?,?,?,?,?,?,?,?)";
    
    /** SELECT SQL statement */
    public static final String SQL_SELECT = "SELECT USR.id,USR.firstname,USR.lastname,USR.email,USR.login,USR.password,USR.disabled,USR.disabledText FROM USR";
    
    /** UPDATE SQL statement */
    public static final String SQL_UPDATE = "UPDATE USR SET firstname=?,lastname=?,email=?,login=?,password=?,disabled=?,disabledText=?";
    
    /** Delete SQL Statement */
    public static final String SQL_DELETE = "DELETE FROM USR";

    /** Active connection */
    private Connection cnn;
    
    
////////////////////////////////////
// Constructors
////////////////////////////////////

    public UserDAO( Connection cnn )
    {
        if ( cnn == null )  throw new IllegalArgumentException( "cnn is null" );
        
        this.cnn = cnn;
    }
    

////////////////////////////////////
// Public methods
////////////////////////////////////
    
    /**
     * Persist a User into the database
     *
     * @param       User to persist
     * @return      value of the primary key of the object persisted
     * @throws      SQLException if any error occurs
     */
    public int create( UserDTO data ) throws SQLException
    {
        PreparedStatement stmt = null;
        try
        {

            // Create the object
            stmt = cnn.prepareStatement( SQL_INSERT, ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY );
            
                                                
        int value1 = data.getId();
        if ( value1 != 0 )  stmt.setInt( 1, value1 ); else stmt.setNull( 1, Types.INTEGER );
                                
        stmt.setString( 2, data.getFirstname() );
                                
        stmt.setString( 3, data.getLastname() );
                                
        stmt.setString( 4, data.getEmail() );
                                
        stmt.setString( 5, data.getLogin() );
                                
        stmt.setString( 6, data.getPassword() );
                                
        stmt.setBoolean( 7, data.getDisabled() );
                                
        stmt.setString( 8, data.getDisabledText() );
    
            stmt.executeUpdate();
            
            return data.getId();
        }
        finally
        {
            if ( stmt != null )
            {
                try{    stmt.close();   } catch( Exception e )  { e.printStackTrace(); }
            }
        }
    }

    /**
     * Persist modification on a User into the database
     *
     * @param       User to persist
     * @return      true if the object has been updated, false if not
     * @throws      SQLException if any error occurs
     */
    public boolean update( UserDTO data ) throws SQLException
    {
        PreparedStatement stmt = null;


        if ( exists( data ) )
        {
            // Update the object
            try
            {
                stmt = cnn.prepareStatement( SQL_UPDATE + " WHERE id=?", ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY );

                
                                    
        stmt.setString( 1, data.getFirstname() );
                
                                    
        stmt.setString( 2, data.getLastname() );
                
                                    
        stmt.setString( 3, data.getEmail() );
                
                                    
        stmt.setString( 4, data.getLogin() );
                
                                    
        stmt.setString( 5, data.getPassword() );
                
                                    
        stmt.setBoolean( 6, data.getDisabled() );
                
                                    
        stmt.setString( 7, data.getDisabledText() );
                                                                
        int value8 = data.getId();
        if ( value8 != 0 )  stmt.setInt( 8, value8 ); else stmt.setNull( 8, Types.INTEGER );
                    
                stmt.executeUpdate();
                return true;
            }
            finally
            {
                if ( stmt != null )
                {
                    try{    stmt.close();   } catch( Exception e )  { e.printStackTrace(); }
                }
            }
        }
        return false;
    }

    /**
     * Remove a User from the database
     *
     * @param       pk  Primary key of the User to remove
     * @throws      SQLException if any error occurs
     */
    public void removeByPK( int pk ) throws SQLException
    {
        PreparedStatement stmt = null;
        try
        {
            // Remove the object
            stmt = cnn.prepareStatement( SQL_DELETE + " WHERE id=?", ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY );
            
                                                    
        int value1 = pk;
        if ( value1 != 0 )  stmt.setInt( 1, value1 ); else stmt.setNull( 1, Types.INTEGER );
                
            stmt.executeUpdate();
        }
        finally
        {
            if ( stmt != null )
            {
                try{    stmt.close();   } catch( Exception e )  { e.printStackTrace(); }
            }
        }
    }
    
    /**
     * Find a User by its primary key
     *
     * @param pk    primary key of the User requested
     * @return      User found, <code>null</code> if nothing found
     * @throws      SQLException if any error occurs
     */
    public UserDTO findByPK( int pk ) throws SQLException
    {
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try
        {
            String sql = SQL_SELECT + " WHERE USR.id=?";
            stmt = cnn.prepareStatement( sql, ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY );
                
                                                    
        int value1 = pk;
        if ( value1 != 0 )  stmt.setInt( 1, value1 ); else stmt.setNull( 1, Types.INTEGER );
    
            rs = stmt.executeQuery();
            return rs.next() ? newDataObject( rs ) : null;
        }
        finally
        {
            if ( rs != null )
            {
                try{    rs.close();   } catch( Exception e )  { e.printStackTrace(); }
            }
            if ( stmt != null )
            {
                try{    stmt.close();   } catch( Exception e )  { e.printStackTrace(); }
            }
        }
    }

                        
    /**
     * Find a user by its name
     *
      * @param login     User's login
      * @return                User found, <code>null</code> if nothing found
     * @throws SQLException   if any error occurs
     */
    public UserDTO findByLogin ( String login ) throws SQLException
    {
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try
        {
            String sql = SQL_SELECT + " WHERE login=?";
            stmt = cnn.prepareStatement( sql, ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY );


                                
        stmt.setString( 1, login );
    
            rs = stmt.executeQuery();


            return rs.next() ? newDataObject( rs ) : null;
        }
        finally
        {
            if ( rs != null )
            {
                try{    rs.close();   } catch( Exception e )  { e.printStackTrace(); }
            }
            if ( stmt != null )
            {
                try{    stmt.close();   } catch( Exception e )  { e.printStackTrace(); }
            }
        }
    }


//////////////////////////////////////////////////
// Private methods
//////////////////////////////////////////////////

    private boolean exists( UserDTO data ) throws SQLException
    {
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try
        {
            stmt = cnn.prepareStatement( "SELECT id FROM USR WHERE id=?", ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY );
            
                                                    
        int value1 = data.getId();
        if ( value1 != 0 )  stmt.setInt( 1, value1 ); else stmt.setNull( 1, Types.INTEGER );
                
            rs = stmt.executeQuery();
            return rs.next();
        }
        finally
        {
            if ( rs != null )
            {
                try{    rs.close();   } catch( Exception e )  { e.printStackTrace(); }
            }
            if ( stmt != null )
            {
                try{    stmt.close();   } catch( Exception e )  { e.printStackTrace(); }
            }
        }
    }

    private Set filter( ResultSet rs, int offset, int maxcount ) throws SQLException
    {
        HashSet set = new HashSet();
        for( int i=0, count=0 ; rs.next() && ( maxcount > count ) ; i++ )
        {
            if ( i >= offset )
            {
                set.add( newDataObject( rs ) );
                count++;
            }
        }
        return set;
    }

    private UserDTO newDataObject( ResultSet rs ) throws SQLException
    {
        UserDTO data = new UserDTO();
        

                        data.setId( rs.getInt( 1 ) );

                        data.setFirstname( rs.getString( 2 ) );

                        data.setLastname( rs.getString( 3 ) );

                        data.setEmail( rs.getString( 4 ) );

                        data.setLogin( rs.getString( 5 ) );

                        data.setPassword( rs.getString( 6 ) );

                        data.setDisabled( rs.getBoolean( 7 ) );

                        data.setDisabledText( rs.getString( 8 ) );

        return data;
    }
}
