/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.sql.SQLException;
import java.util.ArrayList;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.NativeStruct;
import org.postgresql.pljava.internal.Oid;
import org.postgresql.pljava.internal.Portal;

public class ExecutionPlan
extends NativeStruct {
    private static final ArrayList s_deathRow = new ArrayList();
    private boolean m_isDurable = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Portal cursorOpen(String string, Object[] objectArray) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return this._cursorOpen(string, objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCursorPlan() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return this._isCursorPlan();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execp(Object[] objectArray, int n) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return this._execp(objectArray, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutionPlan prepare(String string, Oid[] oidArray) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return ExecutionPlan._prepare(string, oidArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            this._invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeDurable() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            if (this.m_isDurable) {
                return;
            }
            this._savePlan();
            this.m_isDurable = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() {
        if (this.m_isDurable && this.isValid()) {
            long l = this.getNative();
            if (Backend.isCallingJava()) {
                this.invalidate();
            } else {
                ArrayList arrayList = s_deathRow;
                synchronized (arrayList) {
                    s_deathRow.add(new Long(l));
                    ExecutionPlan.setDeathRowFlag(true);
                }
            }
        }
    }

    private native void _savePlan() throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long[] getDeathRow() {
        ArrayList arrayList = s_deathRow;
        synchronized (arrayList) {
            int n = s_deathRow.size();
            long[] lArray = new long[n];
            while (--n >= 0) {
                lArray[n] = (Long)s_deathRow.get(n);
            }
            s_deathRow.clear();
            ExecutionPlan.setDeathRowFlag(false);
            return lArray;
        }
    }

    private static native void setDeathRowFlag(boolean var0);

    private native Portal _cursorOpen(String var1, Object[] var2) throws SQLException;

    private native boolean _isCursorPlan() throws SQLException;

    private native int _execp(Object[] var1, int var2) throws SQLException;

    private static native ExecutionPlan _prepare(String var0, Oid[] var1) throws SQLException;

    private native void _invalidate();
}

