<?php

/**************************************************
Program name:	get_array_primarykeys.inc.php

Author:		Joe Mitchell (jwm@basecoach.com)
		Dan Wilson (phpPgAdmin@acucore.com)

Description:	Get array of all table(column) combinations where 
		column has Primary Key attribute.
			
Create Date:	6/29/01 

Modified Date(s):	
**************************************************/

// SQL string to get all table(column) combinations
// Where UNIQUE is TRUE

$sql_get = "
		SELECT 
			ic.relname AS index_name, 
			bc.relname AS table_name, 
			ta.attname AS field,
			i.indisunique AS unique_key,
			i.indisprimary AS primary_key 
		FROM 
			pg_class bc,
			pg_class ic,
			pg_index i,
			pg_attribute ta,
			pg_attribute ia 
		WHERE 
			bc.oid = i.indrelid
			AND ic.relname NOT LIKE 'pg%'
			AND ic.oid = i.indexrelid
			AND ia.attrelid = i.indexrelid
			AND ta.attrelid = bc.oid
			AND ta.attrelid = i.indrelid
			AND ta.attnum = i.indkey[ia.attnum-1]
			AND i.indisprimary = 't' 
";



// Connect and Execute the SQL statement ($sql_get)
include($PATH_INCLUDE."connect_exec.inc.php");


// Result array and add --none-- value to array
unset($aryPrimaryKeys);


// Build aryPrimaeryKeys
for ($i = 0; $i < $num_rows; $i++) {
	
	# Check for multiple column keys
	$numkey = 1;
	if ($sql_array[$i][0] == $sql_array[$i+1][0]) {
		$numkey = 2;
	} 
	if ($sql_array[$i][0] == $sql_array[$i+2][0]) {
		$numkey = 3;
	}
	if ($sql_array[$i][0] == $sql_array[$i+3][0]) {
		$numkey = 4;
	}


	if ($numkey == 1) {
		$aryPrimaryKeys[$i] = dq($sql_array[$i][1])."(".dq($sql_array[$i][2]).")";
	} elseif ($numkey == 2) {
		$aryPrimaryKeys[$i] = dq($sql_array[$i][1])."(".dq($sql_array[$i][2]).", ".dq($sql_array[$i+1][2]).")";
	} elseif ($numkey == 3) {
		$aryPrimaryKeys[$i] = dq($sql_array[$i][1])."(".dq($sql_array[$i][2]).", ".dq($sql_array[$i+1][2]).", ".dq($sql_array[$i+2][2]).")";
	} elseif ($numkey == 4) {
		$aryPrimaryKeys[$i] = dq($sql_array[$i][1])."(".dq($sql_array[$i][2]).", ".dq($sql_array[$i+1][2]).", ".dq($sql_array[$i+2][2]).", ".dq($sql_array[$i+3][2]).")";
	} 
	
	if ($numkey > 1) {
		$i = $i + $numkey - 1 ;
	}
}
# need sort to eliminate empty indexes that select_box() doesn't like
if (!empty($aryPrimaryKeys)) {
	sort($aryPrimaryKeys);
}

?>
