VERSION 5.00
Begin VB.Form frmViews 
   Caption         =   "Views"
   ClientHeight    =   4050
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   8205
   Icon            =   "frmViews.frx":0000
   LinkTopic       =   "Form1"
   MDIChild        =   -1  'True
   ScaleHeight     =   4050
   ScaleWidth      =   8205
   Begin VB.CommandButton cmdViewData 
      Caption         =   "&View Data"
      Height          =   330
      Left            =   45
      TabIndex        =   14
      ToolTipText     =   "Edit the comment for the selected View."
      Top             =   1260
      Width           =   1410
   End
   Begin VB.CommandButton cmdComment 
      Caption         =   "&Edit Comment"
      Height          =   330
      Left            =   45
      TabIndex        =   12
      ToolTipText     =   "Edit the comment for the selected View."
      Top             =   855
      Width           =   1410
   End
   Begin VB.Frame fraDetails 
      Caption         =   "View Details"
      Height          =   4020
      Left            =   4500
      TabIndex        =   4
      Top             =   0
      Width           =   3660
      Begin VB.TextBox txtDefinition 
         BackColor       =   &H8000000F&
         Height          =   1275
         Left            =   90
         Locked          =   -1  'True
         MultiLine       =   -1  'True
         ScrollBars      =   2  'Vertical
         TabIndex        =   13
         Top             =   1125
         Width           =   3480
      End
      Begin VB.TextBox txtOID 
         BackColor       =   &H8000000F&
         Height          =   285
         Left            =   900
         Locked          =   -1  'True
         TabIndex        =   7
         Top             =   225
         Width           =   2670
      End
      Begin VB.TextBox txtOwner 
         BackColor       =   &H8000000F&
         Height          =   285
         Left            =   900
         Locked          =   -1  'True
         TabIndex        =   6
         Top             =   540
         Width           =   2670
      End
      Begin VB.TextBox txtComments 
         BackColor       =   &H8000000F&
         Height          =   1320
         Left            =   90
         Locked          =   -1  'True
         MultiLine       =   -1  'True
         ScrollBars      =   2  'Vertical
         TabIndex        =   5
         Top             =   2610
         Width           =   3480
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "OID"
         Height          =   195
         Index           =   0
         Left            =   90
         TabIndex        =   11
         Top             =   270
         Width           =   285
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "Owner"
         Height          =   195
         Index           =   1
         Left            =   90
         TabIndex        =   10
         Top             =   585
         Width           =   465
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "Definition"
         Height          =   195
         Index           =   5
         Left            =   90
         TabIndex        =   9
         Top             =   900
         Width           =   660
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "Comments"
         Height          =   195
         Index           =   8
         Left            =   90
         TabIndex        =   8
         Top             =   2430
         Width           =   735
      End
   End
   Begin VB.ListBox lstView 
      Height          =   3960
      Left            =   1485
      TabIndex        =   3
      Top             =   45
      Width           =   2985
   End
   Begin VB.CommandButton cmdRefresh 
      Caption         =   "&Refresh"
      Height          =   330
      Left            =   45
      TabIndex        =   2
      ToolTipText     =   "Refresh the list of Views."
      Top             =   2250
      Width           =   1410
   End
   Begin VB.CommandButton cmdDropView 
      Caption         =   "&Drop View"
      Height          =   330
      Left            =   45
      TabIndex        =   1
      ToolTipText     =   "Delete the selected View."
      Top             =   450
      Width           =   1410
   End
   Begin VB.CommandButton cmdCreateView 
      Caption         =   "&Create View"
      Height          =   330
      Left            =   45
      TabIndex        =   0
      ToolTipText     =   "Create a new View."
      Top             =   45
      Width           =   1410
   End
   Begin VB.Frame Frame1 
      Caption         =   "Show System:"
      Height          =   525
      Left            =   45
      TabIndex        =   15
      Top             =   1665
      Width           =   1380
      Begin VB.CheckBox chkSystem 
         Caption         =   "Views"
         Height          =   225
         Left            =   120
         TabIndex        =   16
         ToolTipText     =   "Select to view system views"
         Top             =   225
         Width           =   1065
      End
   End
End
Attribute VB_Name = "frmViews"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' pgAdmin - PostgreSQL db Administration/Management for Win32
' Copyright (C) 1998 - 2001, Dave Page

' This program is free software; you can redistribute it and/or
' modify it under the terms of the GNU General Public License
' as published by the Free Software Foundation; either version 2
' of the License, or (at your option) any later version.

' This program is distributed in the hope that it will be useful,
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
' GNU General Public License for more details.

' You should have received a copy of the GNU General Public License
' along with this program; if not, write to the Free Software
' Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Option Explicit
Dim rsView As New Recordset

Private Sub lstView_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
On Error GoTo Err_Handler
  If Button = 2 Then PopupMenu fMainForm.mnuCTXViews
Err_Handler: If Err.Number <> 0 Then LogError Err, "frmViews, lstViews_MouseUp"
End Sub

Private Sub chkSystem_Click()
On Error GoTo Err_Handler
  cmdRefresh_Click
  Exit Sub
Err_Handler: If Err.Number <> 0 Then LogError Err, "frmViews, ChkSystem_Click"
End Sub

Public Sub cmdViewData_Click()
On Error GoTo Err_Handler
Dim Response As Integer
Dim Tuples As Long
Dim rsQuery As New Recordset
  If lstView.Text = "" Then
    MsgBox "You must select a view to view!", vbExclamation, "Error"
    Exit Sub
  End If
  If rsQuery.State <> adStateClosed Then rsQuery.Close
  LogMsg "Executing: SELECT count(*) As records FROM " & QUOTE & lstView.Text & QUOTE
  rsQuery.Open "SELECT count(*) As records FROM " & QUOTE & lstView.Text & QUOTE, gConnection, adOpenForwardOnly
  If Not rsQuery.EOF Then
    Tuples = rsQuery!Records
  Else
    Tuples = 0
  End If
  If rsQuery.State <> adStateClosed Then rsQuery.Close
  If Tuples > 1000 Then
    Response = MsgBox("That table contains " & Tuples & " rows which may take some time to load! Do you wish to continue?", _
    vbExclamation + vbYesNo, "Warning")
    If Response = vbNo Then Exit Sub
  End If
  Dim DataForm As New frmSQLOutput
  LogMsg "Executing: SELECT * FROM " & QUOTE & lstView.Text & QUOTE
  rsQuery.Open "SELECT * FROM " & QUOTE & lstView.Text & QUOTE, gConnection, adOpenForwardOnly, adLockReadOnly
  Load DataForm
  DataForm.Display rsQuery
  DataForm.Show
  DataForm.ZOrder 0
  Exit Sub
Err_Handler: If Err.Number <> 0 Then LogError Err, "frmViews, cmdViewData_Click"
End Sub

Private Sub Form_Unload(Cancel As Integer)
On Error Resume Next
  Set rsView = Nothing
End Sub

Public Sub cmdComment_Click()
On Error GoTo Err_Handler
  If txtOID.Text = "" Then
    MsgBox "You must select a View to edit the comment for.", vbExclamation, "Error"
    Exit Sub
  End If
  CallingForm = "frmViews"
  OID = txtOID.Text
  Load frmComments
  frmComments.Show
  Exit Sub
Err_Handler: If Err.Number <> 0 Then LogError Err, "frmViews, cmdComment_Click"
End Sub

Public Sub cmdCreateView_Click()
On Error GoTo Err_Handler
  Load frmAddView
  frmAddView.Show
  Exit Sub
Err_Handler: If Err.Number <> 0 Then LogError Err, "frmViews, cmdCreateView_Click"
End Sub

Public Sub cmdDropView_Click()
On Error GoTo Err_Handler
  If lstView.Text = "" Then
    MsgBox "You must select a View to delete!", vbExclamation, "Error"
    Exit Sub
  End If
  If MsgBox("Are you sure you wish to delete this View?", vbYesNo + vbQuestion, _
            "Confirm View Delete") = vbYes Then
    StartMsg "Dropping View..."
    fMainForm.txtSQLPane.Text = "DROP VIEW " & QUOTE & lstView.Text & QUOTE
    LogMsg "Executing: DROP VIEW " & QUOTE & lstView.Text & QUOTE
    gConnection.Execute "DROP VIEW " & QUOTE & lstView.Text & QUOTE
    LogQuery "DROP VIEW " & QUOTE & lstView.Text & QUOTE
    cmdRefresh_Click
    EndMsg
  End If
  Exit Sub
Err_Handler:
  EndMsg
  If Err.Number <> 0 Then LogError Err, "frmViews, cmdDropView_Click"
End Sub

Public Sub cmdRefresh_Click()
On Error GoTo Err_Handler
  StartMsg "Retrieving View Names..."
  lstView.Clear
  txtOID.Text = ""
  txtDefinition.Text = ""
  txtComments.Text = ""
  txtOwner.Text = ""
  If rsView.State <> adStateClosed Then rsView.Close
  If chkSystem.Value = 1 Then
    LogMsg "Executing: SELECT * FROM pgadmin_views ORDER BY view_name"
    rsView.Open "SELECT * FROM pgadmin_views ORDER BY view_name", gConnection, adOpenDynamic
  Else
    LogMsg "Executing: SELECT * FROM pgadmin_views WHERE view_oid > " & LAST_SYSTEM_OID & " AND view_name NOT LIKE 'pgadmin_%' ORDER BY view_name"
    rsView.Open "SELECT * FROM pgadmin_views WHERE view_oid > " & LAST_SYSTEM_OID & " AND view_name NOT LIKE 'pgadmin_%' ORDER BY view_name", gConnection, adOpenDynamic
  End If
  While Not rsView.EOF
    lstView.AddItem rsView!view_name
    rsView.MoveNext
  Wend
  EndMsg
  Exit Sub
Err_Handler:
  EndMsg
  If Err.Number <> 0 Then LogError Err, "frmViews, cmdRefresh_Click"
End Sub

Private Sub Form_Load()
On Error GoTo Err_Handler
  LogMsg "Loading Form: " & Me.Name
  Me.Width = 8325
  Me.Height = 4455
  cmdRefresh_Click
  Exit Sub
Err_Handler: If Err.Number <> 0 Then LogError Err, "frmViews, Form_Load"
End Sub

Private Sub Form_Resize()
On Error GoTo Err_Handler
  If Me.WindowState <> 1 Then
    If Me.WindowState = 0 Then
      If Me.Width < 8325 Then Me.Width = 8325
      If Me.Height < 4455 Then Me.Height = 4455
    End If
    lstView.Height = Me.ScaleHeight
    lstView.Width = Me.ScaleWidth - lstView.Left - fraDetails.Width - 25
    fraDetails.Left = lstView.Left + lstView.Width + 25
    fraDetails.Height = Me.ScaleHeight
    txtComments.Height = fraDetails.Height - txtComments.Top - 100
  End If
  Exit Sub
Err_Handler: If Err.Number <> 0 Then LogError Err, "frmViews, Form_Resize"
End Sub

Public Sub lstView_Click()
On Error GoTo Err_Handler
  If lstView.Text <> "" Then
    StartMsg "Retrieving View Info..."
    If rsView.BOF <> True Then rsView.MoveFirst
    MoveRS rsView, lstView.ListIndex
    txtOID.Text = rsView!view_oid & ""
    txtOwner.Text = rsView!view_owner & ""
    txtDefinition.Text = rsView!view_definition & ""
    txtComments.Text = rsView!view_comments & ""
    EndMsg
  End If
  Exit Sub
Err_Handler:
  EndMsg
  If Err.Number <> 0 Then LogError Err, "frmViews, lstView_Click"
End Sub
