# README of the Y2038 cppcheck addon

## Contents

- [README of the Y2038 cppcheck addon](#readme-of-the-y2038-cppcheck-addon)
  - [Contents](#contents)
  - [What is Y2038?](#what-is-y2038)
  - [What is the Y2038 cppcheck addon?](#what-is-the-y2038-cppcheck-addon)
  - [How does the Y2038 cppcheck addon work?](#how-does-the-y2038-cppcheck-addon-work)
    - [Primary Usage: Cppcheck Addon Integration (`y2038.py`)](#primary-usage-cppcheck-addon-integration-y2038py)
      - [Implementation Details](#implementation-details)
  - [Requirements](#requirements)
  - [How to use the Y2038 cppcheck addon](#how-to-use-the-y2038-cppcheck-addon)
    - [**Auditing Your Project for Y2038 Compliance**](#auditing-your-project-for-y2038-compliance)
    - [**CI/CD Integration**](#cicd-integration)
  - [Testing](#testing)
    - [Running Y2038 Addon Tests](#running-y2038-addon-tests)
    - [Test Coverage](#test-coverage)
    - [Test Structure](#test-structure)

---

## What is Y2038?

In a few words:

Most operating systems and programming environments represent the current time as the number of seconds since the Unix epoch. In C and C++ this is exposed by time() and std::time(), with the Unix epoch defined as 00:00:00 UTC on 1 January 1970.

Typically this representation is stored as a 64-bit signed quantity.
Some systems, mainly embedded systems and older systems, still use a 32-bit signed
time_t representation.

On January 19th, 2038 at 03:14:07 GMT, such 32-bit representations will reach
their maximum positive value.

What happens then is unpredictable: system time might roll back to December
13th, 1901 at 19:55:13, or it might keep running on until February 7th, 2106
at 06:28:15 GMT, or the computer may freeze, or just about anything you can
think of, plus a few ones you can't.

The workaround for this is to switch to a 64-bit signed representation of time
as seconds from the Unix epoch. This representation will work for more than 250
billion years.

Working around Y2038 requires fixing the Linux kernel, the C libraries, and
any user code around which uses 32-bit epoch representations.

There is Y2038-proofing work in progress on the Linux and GNU glibc front.

## What is the Y2038 cppcheck addon?

The Y2038 cppcheck addon is a tool to help detect code which might need fixing
because it is Y2038-unsafe. This may be because it uses types or functions from
GNU libc or from the Linux kernel which are known not to be Y2038-proof.

## How does the Y2038 cppcheck addon work?

The Y2038 addon is a comprehensive tool designed to audit your project for Y2038 compliance. It provides a streamlined, intelligent approach to Y2038 analysis.

### Primary Usage: Cppcheck Integration with Project Files

The Y2038 addon integrates seamlessly with cppcheck's core project parsing infrastructure. For optimal analysis, use the addon with project files:

```bash
cppcheck --project=build/compile_commands.json --addon=y2038
```

For single files, you can also use:
```bash
cppcheck --addon=y2038 source_file.c
```

#### Implementation Details

The addon leverages cppcheck's built-in project parsing capabilities:

- **Core Integration**: Y2038-related compiler flags are extracted by cppcheck core during project parsing and passed through dump file configuration
- **Automatic Flag Detection**: Cppcheck automatically detects Y2038-relevant flags (`-D_TIME_BITS=64`, `-D_FILE_OFFSET_BITS=64`, `-D_USE_TIME_BITS64`) from compilation commands
- **Clean Architecture**: No redundant file parsing - cppcheck handles project files once, addon focuses on analysis
- **Priority Logic**: Dump file configuration (from cppcheck's project parsing) takes precedence over source code `#define` statements
- **Source Fallback**: When no project configuration is available, the addon analyzes source code `#define` statements

This architecture ensures optimal performance and maintains clean separation of concerns between cppcheck core (project parsing) and addon (analysis logic).

The output is the standard Cppcheck analysis report, focused on Y2038-related issues.

## Requirements

The Y2038 addon works with any cppcheck installation and requires no additional dependencies beyond cppcheck itself.

For optimal Y2038 analysis, ensure your project uses a supported build system that generates `compile_commands.json`:

- **CMake**: Use `-DCMAKE_EXPORT_COMPILE_COMMANDS=ON`
- **Bear**: For Make/Autotools projects, use `bear` to generate compile commands
- **Ninja**: Use `ninja -t compdb` to generate compile commands
- **Bazel**: Use `bazel aquery` with appropriate flags

If using `bear` for Make-based projects, install it via your package manager:

```bash
# On Debian/Ubuntu
sudo apt-get install bear

# On Fedora
sudo dnf install bear

# On macOS (using Homebrew)
brew install bear
```

## How to use the Y2038 cppcheck addon

### **Auditing Your Project for Y2038 Compliance**

The Y2038 addon seamlessly integrates with your existing cppcheck workflow.

**For projects with compile_commands.json (recommended):**

```bash
cppcheck --project=build/compile_commands.json --addon=y2038
```

**For single file analysis:**

```bash
cppcheck --addon=y2038 source_file.c
```

**For project-wide analysis without compile_commands.json:**

```bash
cppcheck --addon=y2038 src/
```

The integration automatically:

1.  **Extracts Y2038 flags** from your project's compilation commands via cppcheck's project parsing
2.  **Passes flag information** through dump file configuration to the addon
3.  **Analyzes source code** with proper Y2038 context from both build system and source directives
4.  **Reports Y2038 issues** using cppcheck's standard error reporting format

### **CI/CD Integration**

For CI/CD integration, use the Y2038 addon with your project's build configuration:

```sh
# Example CI script with compile_commands.json
#!/bin/bash
# Generate compile_commands.json (if not already available)
cmake -DCMAKE_EXPORT_COMPILE_COMMANDS=ON -B build
# or: bear -- make

# Run Y2038 analysis
cppcheck --project=build/compile_commands.json --addon=y2038 --error-exitcode=1

# The addon will return a non-zero exit code if Y2038 issues are found.
# The output is the standard Cppcheck report.
```

**For projects without compile_commands.json:**

```sh
# Example CI script for source-only analysis
#!/bin/bash
cppcheck --addon=y2038 --error-exitcode=1 src/
```
