/*
 * Copyright (C) The MX4J Contributors.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package mx4j.tools.adaptor.interceptor;

import mx4j.log.Logger;

/**
 * @version $Revision: 1.3 $
 */
public class LoggerAdaptorInterceptor extends AdaptorInterceptor
{
   public LoggerAdaptorInterceptor()
   {
      setEnabled(true);
   }

   public String getType()
   {
      return "logger";
   }

   public InvocationResult invoke(Invocation invocation) throws Exception
   {
      Logger logger = getLogger();
      try
      {
         InvocationResult result = doInvoke(invocation);
         if (logger.isEnabledFor(Logger.DEBUG)) logger.debug("Result is: " + result);
         return result;
      }
      catch (AdaptorInterceptorException x)
      {
         Exception xx = x.getTargetException();
         if (logger.isEnabledFor(Logger.INFO)) logger.info("", xx);
         throw xx;
      }
      catch (Exception x)
      {
         logger.info("", x);
         throw x;
      }
      catch (Error x)
      {
         logger.error("", x);
         throw x;
      }
   }
}
