#if   !defined(__MAZEBUILDER_HPP)
#define  __MAZEBUILDER_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   


#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__BUILDER_HPP)
#include <Builder.hpp>
#endif

#if   !defined(__MAP_HPP)
#include <Map.hpp>
#endif

#if   !defined(__PAIR_HPP)
#include <Pair.hpp>
#endif

#if   !defined(__NAMEIDENTIFIER_HPP)
#include <NameIdentifier.hpp>
#endif

#if   !defined(__MAZE_HPP)
#include <Maze.hpp>
#endif

#if   !defined(__ROOM_HPP)
#include <Room.hpp>
#endif


//
// We track the rooms here for construction as well
// as a room to room door map
//

CORELINUX_PAIR( DoorPair, RoomNumber, RoomNumber );
CORELINUX_MULTIMAP(  Direction,  DoorPair,  less<Direction> ,  SideMap );

//
// Forward class declarations
//

DECLARE_CLASS( MazeBuilderFactory );
DECLARE_CLASS( MazeBuilder );

/**
MazeBuilder implements the Builder pattern. It constructs a 
simple maze by utilizing the MazeBuilderFactory for the various parts:
Rooms, Doors, and Walls.

It lets the default "create" of Builder to be exposed because
the work is really done in the createProduct implementation here
*/

class MazeBuilder : public corelinux::Builder<Maze,NameIdentifier>
{
public:

   //
   // Constructors and destructor
   //

                        /// Default contructor 

                        MazeBuilder( MazeBuilderFactoryPtr );

                        /// Copy constructor

                        MazeBuilder( MazeBuilderCref );

                        /// Virtual Destructor

   virtual              ~MazeBuilder( void );

   //
   // Operator overload
   //

            /// Equality operator

            bool  operator==( MazeBuilderCref aRef ) const;

protected:

   //
   // Constructors
   //

                        /// Default constructor

                        MazeBuilder( void ) throw( CORELINUX(Assertion) );

   //
   // Operator overload
   //

            /// Assignment operator

            MazeBuilderRef operator=( MazeBuilderCref ) 
                              throw( CORELINUX(Assertion) );

   //
   // Accessors
   //

            /// Base method to associate doors to rooms

   virtual  SideMapCref  getSideMap( void ) const;

   //
   // Mutators
   //
            /// Base method to construct layout template

   virtual  void        constructSideMap( void );

            /// Our method for construction of Room parts

   virtual  void  createRooms( MazePtr ) const;

            /// Our method for constructing and connecting 
            /// doors to rooms

   virtual  void  connectRoomsWithDoors( MazePtr ) const;

            /// Our method for destroying all doors

   virtual  void  disconnectAndDestroyDoors( MazePtr ) const;

   //
   // Factory methods
   //

            /// Pure virtual createProduct 

   virtual  MazePtr createProduct( void ) const;

            /// Pure virtual destroyProduct 

   virtual  void  destroyProduct( MazePtr ) const ;

private:

            SideMap  theSideMap;

};

#endif // if   !defined(__MAZEBUILDER_HPP)

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.4 $
   $Date: 2000/08/31 22:50:31 $
   $Locker:  $
*/

